# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply master page and logo settings to all sites in all
# site collections of all web applications
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# Relative URL to the logo
$logoUrl = "/SiteAssets/logo.png"

# Logo description
$logoDescription = "My PowerShell Site"

# Relative URL to the master page
$masterUrl = "/_catalogs/masterpages/seattle.master"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Iterate through each content web application on the SharePoint farm
foreach ($webApp in (Get-SPWebApplication))
{
	# Iterate through each site collection in the web application
	foreach ($site in $webApp.Sites)
	{
		# Check that the site collection is in 2013 mode and not 2010 mode
		if ($site.CompatibilityLevel eq 15)
		{
			# Iterate through each site in the site collection
			foreach ($web in $site.AllWebs)
			{
				# Ensure the site exists
				if ($web.Exists)
				{
					# Set the logo and master page properties
					$web.SiteLogoUrl = $logoUrl
					$web.SiteLogoDescription = $logoDescription
					$web.MasterUrl = $masterUrl
					$web.CustomMasterUrl = $masterUrl

					# Update the Site
					$web.Update()
				}

				# Dispose of the site object
				$web.Dispose()
			}
		}

		# Dispose of the site collection object
		$site.Dispose()
	}
}

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 